<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Prescription - <?php echo e($prescription->prescription_number); ?></title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 20px;
        }
        .header {
            margin-bottom: 30px;
        border-bottom: 2px solid #000;
            padding-bottom: 20px;
        }
        .letterhead {
            max-width: 100%;
            margin-bottom: 20px;
        }
        .doctor-info {
            margin-top: 20px;
        }
        .patient-info {
            margin: 20px 0;
            padding: 15px;
            background-color: #f5f5f5;
        }
        .vitals {
            margin: 20px 0;
        }
        .vitals table {
            width: 100%;
            border-collapse: collapse;
        }
        .vitals td {
            padding: 5px;
            border: 1px solid #ddd;
        }
        .prescription-table {
            width: 100%;
            border-collapse: collapse;
            margin: 20px 0;
        }
        .prescription-table th,
        .prescription-table td {
            border: 1px solid #000;
            padding: 8px;
            text-align: left;
        }
        .prescription-table th {
            background-color: #f0f0f0;
        }
        .footer {
            margin-top: 40px;
            text-align: right;
        }
        .signature {
            margin-top: 60px;
        }
        .stamp {
            position: absolute;
            right: 20px;
            bottom: 100px;
            max-width: 150px;
        }
    </style>
</head>
<body>
    <?php if($letterhead): ?>
        <img src="<?php echo e($letterhead); ?>" alt="Letterhead" class="letterhead">
    <?php else: ?>
        <div class="header">
            <h1><?php echo e($doctor->full_name); ?></h1>
            <p><?php echo e($doctor->qualification); ?></p>
            <p>Practice Number: <?php echo e($doctor->practice_number); ?></p>
        </div>
    <?php endif; ?>

    <div class="doctor-info">
        <p><strong><?php echo e($doctor->full_name); ?></strong></p>
        <p><?php echo e($doctor->qualification); ?></p>
        <p>Practice Number: <?php echo e($doctor->practice_number); ?></p>
        <p><?php echo e($doctor->phone); ?></p>
    </div>

    <div class="patient-info">
        <h3>Patient Information</h3>
        <p><strong>Patient ID:</strong> <?php echo e($patient->patient_id); ?></p>
        <p><strong>Name:</strong> <?php echo e($patient->full_name); ?></p>
        <p><strong>Age:</strong> <?php echo e($patient->date_of_birth ? \Carbon\Carbon::parse($patient->date_of_birth)->age : 'N/A'); ?></p>
        <p><strong>DOB:</strong> <?php echo e($patient->date_of_birth ? \Carbon\Carbon::parse($patient->date_of_birth)->format('m/d/Y') : 'N/A'); ?></p>
        <p><strong>Gender:</strong> <?php echo e($patient->gender ?? 'N/A'); ?></p>
        <p><strong>Payment Mode:</strong> <?php echo e($patient->payment_mode); ?></p>
        <?php if($patient->payment_mode === 'Medical Aid Payment'): ?>
            <p><strong>Medical Aid:</strong> <?php echo e($patient->medical_aid_number ?? 'N/A'); ?></p>
            <p><strong>Main Member:</strong> <?php echo e($patient->main_member ?? 'N/A'); ?></p>
        <?php endif; ?>
    </div>

    <?php if($vitals): ?>
    <div class="vitals">
        <h3>Vitals</h3>
        <table>
            <tr>
                <td><strong>Blood Pressure:</strong> <?php echo e($vitals->blood_pressure ?? 'N/A'); ?> mmHg</td>
                <td><strong>Pulse Rate:</strong> <?php echo e($vitals->pulse_rate ?? 'N/A'); ?> bpm</td>
            </tr>
            <tr>
                <td><strong>Temperature:</strong> <?php echo e($vitals->temperature ?? 'N/A'); ?> °C</td>
                <td><strong>RBS:</strong> <?php echo e($vitals->rbs ?? 'N/A'); ?> %</td>
            </tr>
        </table>
    </div>
    <?php endif; ?>

    <div>
        <h3>Diagnosis: <?php echo e($prescription->diagnosis ?? 'N/A'); ?></h3>
    </div>

    <div>
        <h3>Prescription</h3>
        <table class="prescription-table">
            <thead>
                <tr>
                    <th>#</th>
                    <th>Medicine Name</th>
                    <th>Dosage</th>
                    <th>Frequency</th>
                    <th>Instructions</th>
                    <th>Duration</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($item->item_number); ?></td>
                    <td><?php echo e($item->medicine_name); ?></td>
                    <td><?php echo e($item->dosage); ?></td>
                    <td><?php echo e($item->frequency); ?></td>
                    <td><?php echo e($item->instructions ?? 'N/A'); ?></td>
                    <td><?php echo e($item->duration); ?></td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>

    <?php if($prescription->additional_prescription_details): ?>
    <div>
        <h3>Additional Prescription Details</h3>
        <p><?php echo e($prescription->additional_prescription_details); ?></p>
    </div>
    <?php endif; ?>

    <?php if($stamp): ?>
        <img src="<?php echo e($stamp); ?>" alt="Stamp" class="stamp">
    <?php endif; ?>

    <div class="footer">
        <div class="signature">
            <?php if($signature): ?>
                <img src="<?php echo e($signature); ?>" alt="Signature" style="max-width: 200px;">
            <?php endif; ?>
            <p><strong><?php echo e($doctor->full_name); ?></strong></p>
            <p><?php echo e($doctor->qualification); ?></p>
        </div>
        <p>Date: <?php echo e($prescription->created_at->format('l, F d, Y')); ?></p>
    </div>
</body>
</html>

<?php /**PATH C:\Users\BrainTech\Documents\BEAUTEZ SYSTEM\resources\views/prescriptions/pdf.blade.php ENDPATH**/ ?>